/*
 * Decompiled with CFR 0.152.
 */
package com.service;

import com.dao.HolooSettingsDao;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.SoftwareInfo;
import com.utility.TncJdbc;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;

public class SettingLoader {
    private final LoginDto login;
    private HolooSettingsDao settingDao;

    public SettingLoader(DbConnection dbConnection, LoginDto login) {
        this.settingDao = new HolooSettingsDao(dbConnection);
        this.login = login;
    }

    public <T> T getUserDBField(String fieldName) {
        SqlRowSet rs = this.settingDao.getJdbcTemplate(this.login).queryForRowSet("SELECT " + fieldName + " FROM UserDB WHERE UserCodeInc = ?", new Object[]{this.login.getUserCodeInc()});
        if (!rs.next()) {
            return null;
        }
        if (rs.getObject(fieldName) == null) {
            return null;
        }
        return (T)rs.getObject(fieldName);
    }

    public <T> T getUserDBField(String fieldName, T defValue) {
        Object t = this.getUserDBField(fieldName);
        return (T)(t != null ? t : defValue);
    }

    public int getDollarUnit() {
        return this.settingDao.getMSetup2Integer(this.login, "Dollar_Unit");
    }

    public boolean getSecondUnit() {
        return this.settingDao.getMSetup2Boolean(this.login, "SecondVahed");
    }

    public boolean negativeInvoiceEnabled() {
        return this.settingDao.getMSetupBoolean(this.login, "Negative_Fact");
    }

    public boolean negativeOfSathEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "Negative_OfSath");
    }

    public boolean negativeOfPishEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "NegativePish");
    }

    public boolean negativeOfReqEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "NegativeInReq");
    }

    public boolean calcSoodInForooshEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcSoodInForoosh");
    }

    public boolean calcSoodInForooshEndBuyPriceEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcSoodInForooshEndBuyPrice");
    }

    public boolean hazinehInFactFEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "HazinehInFactF");
    }

    public boolean hazinehInFactKEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "HazinehInFactK");
    }

    public boolean sarshekanHazinehEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "SarshekanHazineh");
    }

    public boolean mustHaveStore() {
        return !this.settingDao.getMSetup2Boolean(this.login, this.login.isAndroid() ? "Res_SelNotExistedArt" : "nspd_SelNotExistedArt");
    }

    public boolean mustHaveStoreInSingleSell() {
        return !this.settingDao.getMSetup2Boolean(this.login, "NSpd_SelNotExistedArt");
    }

    private boolean isAnyDiscount() {
        return this.settingDao.getMSetup2Boolean(this.login, "AnyTakhfif");
    }

    public boolean isDiscountEnabled() {
        return this.isUseRialDiscountPercent() || this.isUsePerRowDiscountPrice();
    }

    public boolean isUseRialDiscountPercent() {
        return this.isAnyDiscount() && this.getDiscountMode() == 2 && this.useRialDiscountPercent();
    }

    public boolean useRialDiscountPercent() {
        return this.settingDao.getMSetup2Boolean(this.login, "DarsadTakhfifR");
    }

    public boolean isProductDiscountPerMGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "MGroupDarsadTakhfif");
    }

    public boolean isProductDiscountPerSGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "SGroupDarsadTakhfif");
    }

    public boolean productDiscountPercentEnabled() {
        return this.getMS2Boolean("ArticleDarsadTakhfif");
    }

    private boolean isTakhfifRAskAllPriceCalcTDarsad() {
        return this.settingDao.getMSetup2Boolean(this.login, "TakhfifRAskAllPriceCalcTDarsad");
    }

    public boolean isUsePerRowDiscountPercent() {
        return this.isAnyDiscount() && this.getDiscountMode() == 2 && this.isTakhfifRAskAllPriceCalcTDarsad() && this.getUseTakhfifPriceOrDarasd() == 0;
    }

    public boolean isUsePerRowDiscountPrice() {
        return this.isAnyDiscount() && this.getDiscountMode() == 2 && this.isTakhfifRAskAllPriceCalcTDarsad() && this.getUseTakhfifPriceOrDarasd() == 1;
    }

    private int getUseTakhfifPriceOrDarasd() {
        return this.settingDao.getMSetup2Integer(this.login, "PriceOrDarasd");
    }

    public int getDiscountMode() {
        return this.settingDao.getMSetup2Integer(this.login, "ModeTakhfif");
    }

    public int getTieredDiscountMode() {
        return this.settingDao.getMSetup2Integer(this.login, "TPelekani_Mode");
    }

    public boolean tieredCommissionEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "TPorsantP");
    }

    public boolean calcCommissionAfterDiscountEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "PorsantAfterTakhfif");
    }

    public boolean perRowCommissionEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "PorsantSatri");
    }

    public boolean commissionDisabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "NoPorsant");
    }

    public boolean midManCommissionEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "Porsant_vaset");
    }

    public boolean mGroupCommissionEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "MGroupPorsant");
    }

    public boolean sGroupCommissionEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "SGroupPorsant");
    }

    public boolean differentCommissionForMidManPerSGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "SGroupForVaseteh");
    }

    public boolean articleCommissionEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "ArticlePorsant");
    }

    public boolean differentCommissionForMidManPerArticle() {
        return this.settingDao.getMSetup2Boolean(this.login, "ArtForVaseteh");
    }

    public int tieredCommissionMode() {
        return this.settingDao.getMSetup2Integer(this.login, "TPorsantP_Mode");
    }

    public boolean differentCommissionForMidManPerMGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "MGroupForVaseteh");
    }

    public boolean isCalcExistInFactByPFact() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcExistInFactByPFact");
    }

    public int getKindVAT() {
        int kindVat = this.isPercentInvoice() && this.isPercentInvoiceSale() ? (this.isCalcVatJ() ? 0 : 1) : 2;
        return kindVat;
    }

    private boolean isPercentInvoice() {
        return this.settingDao.getMSetup2Boolean(this.login, "DarsadFacture");
    }

    private boolean isPercentInvoiceSale() {
        return this.settingDao.getMSetup2Boolean(this.login, "DarsadFactF");
    }

    public boolean isCalcVatJ() {
        return (this.isVatInvoiceScotSell() || this.isVATInvoiceScotBuy() || this.isVatInvoiceLevySell() || this.isVATInvoiceLevyBuy()) && this.settingDao.getMSetup2Boolean(this.login, "CalcVat_J");
    }

    public boolean isCalcVatK() {
        return this.settingDao.getMSetup2Boolean(this.login, "CalcVat_K");
    }

    private Boolean andBooleans(SqlRowSet rowSet) {
        boolean res = true;
        while (rowSet.next()) {
            res = rowSet.getBoolean("Boolean") && res;
        }
        return res;
    }

    public boolean isVatInvoiceScotSell() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactF", "Darsad_Shahrdary"});
    }

    public boolean isVatInvoiceLevySell() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactF", "Darsad_Amozesh"});
    }

    public boolean isVATInvoiceScotBuy() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactK", "Darsad_Shahrdary"});
    }

    public boolean isVATInvoiceLevyBuy() {
        return (Boolean)this.settingDao.doMultiple(arg_0 -> this.andBooleans(arg_0), "[Boolean]", "0", this.login, new String[]{"DarsadFacture", "DarsadFactK", "Darsad_Amozesh"});
    }

    public double getLevyPercent() {
        return ConvertStr.parseNullSafeDouble((String)this.settingDao.getMSetup2String(this.login, "Darsad_Maliyat", "0"));
    }

    public double getScotPercent() {
        return ConvertStr.parseNullSafeDouble((String)this.settingDao.getMSetup2String(this.login, "Darsad_Avarez", "0"));
    }

    public double getServicePercent() {
        return this.settingDao.getMSetup2Float(this.login, "Res_DarsadService");
    }

    public String getDefaultCustomer() {
        return this.settingDao.getMSetup2String(this.login, "DefPartyCode", null);
    }

    public boolean sendProductsDisabled() {
        return (Boolean)this.getUserDBField("WSendArticle", (Object)false) == false;
    }

    public boolean sendResTablesDisabled() {
        return (Boolean)this.getUserDBField("WSendDesk", (Object)false) == false;
    }

    public boolean sendPicturesDisabled() {
        return (Boolean)this.getUserDBField("WSendArticlePicture", (Object)false) == false;
    }

    public boolean isTaxEnabledOnProducts() {
        return this.settingDao.getMSetup2Boolean(this.login, "ArticleHasTax");
    }

    public int getPrintConfigType() {
        if (this.isCustomPrintDisabled()) {
            return -1;
        }
        return this.settingDao.getMSetup2Integer(this.login, "ResPrintConfigType");
    }

    private boolean isCustomPrintDisabled() {
        return !this.settingDao.getMSetup2Boolean(this.login, "ResHasCutomPrint");
    }

    public boolean isSendActiveResMenuProducts() {
        return this.settingDao.getMSetup2Integer(this.login, "SendArticleType", -1) == 0;
    }

    public boolean userHasLimitedAccessToProducts() {
        return this.settingDao.userHasLimitedAccessToProducts(this.login);
    }

    public boolean showInvoicePayment() {
        return this.login.getSuperVizor() != false || this.settingDao.getMSetup2Boolean(this.login, "Res_OKOtherFactor");
    }

    public boolean showThisUserResInvoicesOnly() {
        return this.login.getSuperVizor() == false && this.settingDao.getMSetup2Boolean(this.login, "Res_FilterUserReservFacts");
    }

    public String getSecondUnitName() {
        return this.settingDao.getMSetup2String(this.login, "ArticleExist2", "\u06a9\u0627\u0631\u062a\u0646");
    }

    public boolean onlySendMidManCustomers() {
        return (Boolean)this.getUserDBField("WSendPartyMiddleman", (Object)false);
    }

    private boolean getMS2Boolean(String name) {
        return this.settingDao.getMSetup2Boolean(this.login, name);
    }

    public boolean isNegativeInvoiceAllowed() {
        return this.settingDao.getMSetupBoolean(this.login, "Negative_Fact");
    }

    public boolean doNotSendCustomerData() {
        return (Boolean)this.getUserDBField("WSendParty", (Object)false) == false;
    }

    public double getMS2Double(String name) {
        return this.settingDao.getMSetup2Float(this.login, name);
    }

    public boolean isUseUnit() {
        return this.settingDao.getMSetup2Boolean(this.login, "M_Unit");
    }

    public boolean isCalcByUnit() {
        return this.settingDao.getMSetup2Boolean(this.login, "SecondVahed") && this.isUseUnit();
    }

    public boolean unitSellPriceEnabled() {
        return this.isUseUnit() && !this.userCannotAccessPriceTypes() && this.settingDao.getMSetup2Boolean(this.login, "UnitSellPrice");
    }

    public boolean searchArtGroupEnabled() {
        return this.getMS2Boolean("SearchMgSgArt");
    }

    public boolean searchArtSubGroupEnabled() {
        return this.getMS2Boolean("SearchBySideGroup");
    }

    public boolean isPartyGroupEnabled() {
        return (Boolean)this.getUserDBField("DBPnlUserPartyGroup", (Object)false) != false && this.freeCodeForCustomer() && (!this.debtFreeCodeOnMoien() || !this.creditFreeCodeOnMoien());
    }

    public boolean freeCodeForCustomer() {
        return this.getMS2Boolean("FreeCodeForCustomer");
    }

    public boolean debtFreeCodeOnMoien() {
        return this.getMS2Boolean("BedCustomerMoienTaf");
    }

    public boolean creditFreeCodeOnMoien() {
        return this.getMS2Boolean("BesCustomerMoienTaf");
    }

    public boolean isCreditAlarmEnabled() {
        return this.getMS2Boolean("AlarmEtebar");
    }

    public boolean isRepeatArtEnabled() {
        return this.getMS2Boolean("AdamTekrarKala");
    }

    public boolean isKitShoes() {
        return (Integer)Objects.requireNonNull(this.settingDao.getJdbcTemplate(this.login).queryForObject("SELECT COUNT(*) CNT FROM ArtExst2", Integer.class)) > 0;
    }

    public long getPartyMaxCode() {
        SqlRowSet rs = this.settingDao.getJdbcTemplate(this.login).queryForRowSet("Select Max(cast(C_Code AS bigint)) maxCode from  CUSTOMER");
        rs.next();
        return rs.getLong("maxCode");
    }

    public boolean isModatTasviehEnabled() {
        return this.getMS2Boolean("SlctModdatTasvieh");
    }

    public boolean isSendCustomerRemainDisabled() {
        return (Boolean)this.getUserDBField("WSendReminParty", (Object)false) == false;
    }

    public boolean isSendPartyOpenChecksRemainDisabled() {
        return (Boolean)this.getUserDBField("WSendReminChequeNotReceive", (Object)false) == false;
    }

    public boolean isEmkanVosoolCheckKharjiEnabled() {
        return this.getMS2Boolean("EmkanVosoolCheckKharji");
    }

    public boolean isCalcExistInReqEnabled() {
        return this.getMS2Boolean("CalcExistInReq");
    }

    public boolean isUseHazHamlInFactEnabled() {
        return this.getMS2Boolean("UseHazHamlInFact");
    }

    public double getRoundNumber() {
        return this.getMS2Double("RoundNumber");
    }

    public boolean picsSavedInDB() {
        return this.getMS2Boolean("CheckBoxSavepicinDb");
    }

    public boolean userHasLimitedAccessToCustomers() {
        return (Boolean)this.getUserDBField("DBPnlUserPartyRight", (Object)false);
    }

    public boolean userHasAccessToInvoiceBeforeTimeRecord() {
        return this.isGetGps() && (Boolean)this.getUserDBField("AccessDroidGPSFact", (Object)false) != false;
    }

    public boolean isGetGps() {
        return this.isGPSEnabled() && new SoftwareInfo(this.getJdbc()).lockAllowsGPS();
    }

    private boolean isGPSEnabled() {
        return (Boolean)this.getUserDBField("AccessDroidGPS", (Object)false);
    }

    public String getMidManId() {
        return this.getUserHasMidMan() ? (String)this.getUserDBField("MiddleManId", (Object)"") : "";
    }

    private boolean getUserHasMidMan() {
        return (Boolean)this.getUserDBField("HasMiddleMan", (Object)false);
    }

    public boolean getReceiveMoienByUser() {
        return (Boolean)this.getUserDBField("WReciveMoeinByUser", (Object)false);
    }

    public boolean userCannotAccessPriceTypes() {
        return (Boolean)this.getUserDBField("DBPnlOrderPriceType", (Object)false) == false;
    }

    public Boolean[] getAllowedPriceTypesForUser() {
        String allowedPriceTypes;
        Object[] allPriceTypes = new Boolean[10];
        if (this.userCannotAccessPriceTypes()) {
            Arrays.fill(allPriceTypes, (Object)false);
            return allPriceTypes;
        }
        SqlRowSet rs = this.getJdbc().queryForRowSet("SELECT IsNull(UserListArt5Price, '') allowedPriceTypes FROM UserDB \n WHERE IsUserLimitArt5Price = 1 AND UserCodeInc = ?", new Object[]{this.login.getUserCodeInc()});
        if (!rs.next() || ConvertStr.isNullOrEmpty((String)(allowedPriceTypes = rs.getString("allowedPriceTypes")))) {
            Arrays.fill(allPriceTypes, (Object)true);
            return allPriceTypes;
        }
        Arrays.fill(allPriceTypes, (Object)false);
        for (String typeIndex : allowedPriceTypes.split(",")) {
            allPriceTypes[Integer.parseInt((String)typeIndex)] = true;
        }
        return allPriceTypes;
    }

    public boolean getUserArtAmountAccess() {
        return (Boolean)this.getUserDBField("DBPnlUserArtAmountRight", (Object)false);
    }

    public boolean isDueDateEnabled() {
        return this.getMS2Boolean("SlctModdatTasvieh");
    }

    public boolean isThreeUnitEnabled() {
        return this.getMS2Boolean("FlagKarton_Basteh");
    }

    public boolean isThreeUnitNewEnabled() {
        return this.getMS2Boolean("CalcNewKartonBasteh");
    }

    public boolean isTwoUnitEnabled() {
        return this.getMS2Boolean("ArticleExist2");
    }

    public boolean mGroupCustomerDiscountEnabled() {
        return this.getMS2Boolean("MGroupTakhfifCust");
    }

    public boolean tieredDiscountEnabled() {
        return this.getMS2Boolean("TPelekani");
    }

    public boolean customerDiscountIneffectiveOnServicesEnabled() {
        return this.getMS2Boolean("TakhfifCustOnlyKala");
    }

    public boolean isArticleExistInvoiceEnabled() {
        return this.getMS2Boolean("ArtExistFact");
    }

    public boolean isUserForbiddenToFetchInvoices() {
        return (Boolean)this.getUserDBField("WSearchFact", (Object)false) == false;
    }

    public boolean onlyAllowUserInvoicesGetOrEdit() {
        return (Boolean)this.getUserDBField("WEditFactByUser", (Object)false);
    }

    public boolean onlyAllowUserOrdersGetOrEdit() {
        return (Boolean)this.getUserDBField("WEditOrderByUser", (Object)false);
    }

    public boolean onlyAllowUserSettlmentsGetOrEdit() {
        return (Boolean)this.getUserDBField("WGetEditUserSettlement", (Object)false);
    }

    public boolean useDueDateForDiscountEnabled() {
        return this.getMS2Boolean("DateModatFlag");
    }

    public boolean showMsgNotBalanceVariety() {
        return this.getMS2Boolean("CShowMsgNotBalancePoshak");
    }

    public boolean useArticlePriceVarietyEnabled() {
        return this.getMS2Boolean("UseArticlePricePoshak");
    }

    public boolean useArticleDiscountVarietyEnabled() {
        return this.getMS2Boolean("UseArticleTakhfifPoshak");
    }

    public boolean minMaxVarietyPriceEnabled() {
        return this.getMS2Boolean("MinMaxArtPricePoshak");
    }

    public String getDefaultDebtMoienCode() {
        String defaultDebtHeading = this.settingDao.getMSetup2String(this.login, "DefBedMoeinCode", "0");
        if (defaultDebtHeading.equalsIgnoreCase("null")) {
            return null;
        }
        if (defaultDebtHeading.length() == 7) {
            return defaultDebtHeading;
        }
        String defaultValue = "103";
        if (this.settingDao.getMSetup2Boolean(this.login, "ConvertNewSarfasl")) {
            defaultValue = "234";
        }
        String colCode = this.getColCode(defaultValue, 5);
        return colCode + defaultDebtHeading;
    }

    public String getDefaultCreditMoienCode() {
        String defaultCreditHeading = this.settingDao.getMSetup2String(this.login, "DefBesMoeinCode", "0");
        if (defaultCreditHeading.equalsIgnoreCase("null")) {
            return null;
        }
        if (defaultCreditHeading.length() == 7) {
            return defaultCreditHeading;
        }
        String defaultValue = "401";
        if (this.settingDao.getMSetup2Boolean(this.login, "ConvertNewSarfasl")) {
            defaultValue = "501";
        }
        String colCode = this.getColCode(defaultValue, 15);
        return colCode + defaultCreditHeading;
    }

    public String getColCode(String defaultValue, int type) {
        SqlRowSet rowSet = this.getJdbc().queryForRowSet("SELECT Col_Code FROM Sarfasl WHERE Moien_code ='' AND TYPE = " + type);
        if (rowSet.next()) {
            defaultValue = rowSet.getString("Col_Code");
        }
        return defaultValue;
    }

    public <T> void getMapMultiple(Function<SqlRowSet, T> doOnEachRow, Consumer<Map<String, T>> consumeResultMap, String valueColName, String valueColDefaultValue, String ... names) {
        consumeResultMap.accept(this.settingDao.getMapMultiple(doOnEachRow, valueColName, valueColDefaultValue, this.login, names));
    }

    public TncJdbc getJdbc() {
        return this.settingDao.getJdbcTemplate(this.login);
    }

    public boolean userNotAllowedToPost() {
        return (Boolean)this.getUserDBField("Res_SaveSpdSel", (Object)false);
    }

    public boolean userNotAllowedToPostTakForoshi() {
        return (Boolean)this.getUserDBField("Nspd_SaveSpdSel", (Object)false);
    }

    public boolean showCustomerChequeForUser() {
        return (Boolean)this.getUserDBField("WshowCustomerChequeForAll", (Object)false) == false;
    }

    public boolean userHasLimitedAccessOnResTables() {
        return (Boolean)this.getUserDBField("DeskSelected", (Object)false);
    }

    @Nullable
    public String getUserAccessiblePrices() {
        return (String)this.getUserDBField("UserListArt5Price", (Object)"");
    }

    public boolean is5PriceCustEnabled() {
        return this.getMS2Boolean("5PriceCust");
    }

    public boolean isAutoBuildArtEnable() {
        return this.settingDao.getMSetup2Boolean(this.login, "AutoBildArt");
    }

    public boolean isNegativeMAvaliehEnable() {
        return this.settingDao.getMSetup2Boolean(this.login, "NegMAvalieh");
    }

    public boolean isBuildWithNoArtEnable() {
        return this.settingDao.getMSetup2Boolean(this.login, "TolidWithNoArt");
    }

    public boolean isAllowSellWithoutPattern() {
        return this.settingDao.getMSetup2Boolean(this.login, "AllowSellWithoutPattern");
    }

    public Boolean isRestaurantSellPatternEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "Use_Res_MaxArtSell");
    }

    public int getRestaurantSellPattern() {
        return this.settingDao.getMSetup2Integer(this.login, "Use_Res_MaxArtSell", -1);
    }

    public boolean isBuildWithEndBuyPrice() {
        return this.settingDao.getMSetup2Boolean(this.login, "GiveEnd_Buy_Price_Tolid");
    }

    public boolean isBuildWithBuyPrice() {
        return this.settingDao.getMSetup2Boolean(this.login, "GiveBuy_Price_Tolid");
    }

    public boolean isBuildWithInputPrice() {
        return this.settingDao.getMSetup2Boolean(this.login, "GiveUseNonePriceInBuy");
    }

    public int getWastagePriceType() {
        return this.settingDao.getMSetup2Integer(this.login, "SelWPrice");
    }

    public boolean transferArticlesWithSameCodes() {
        return this.settingDao.getMSetup2Boolean(this.login, "ChbHavalSameCode");
    }

    public boolean transferArticleInSameGroup() {
        return this.settingDao.getMSetup2Boolean(this.login, "SelectHavalehAllMGroup");
    }

    public String getRestaurantStartPatternTime() {
        return this.settingDao.getMSetup2String(this.login, "Res_Start_Pattern_Time", "00:00");
    }

    public boolean isMoienFilterEnabled() {
        return (Boolean)this.getUserDBField("Moien_Filtered", (Object)false);
    }

    public boolean isTakeawayEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "ResFactureWithoutDesk");
    }

    public boolean isSelectPartyEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "ResChooseCust_InAndroid");
    }

    public boolean isOnlineFactureEnabled() {
        return this.settingDao.getMSetup2Boolean(this.login, "ResUseFact_Online");
    }

    public int getResFactureType() {
        return this.settingDao.getMSetup2Integer(this.login, "ResRadioGroupFact_Online");
    }

    public boolean isAllowDuplicateCell() {
        return this.settingDao.getMSetup2Boolean(this.login, "AddCustWithDuplicateMobile");
    }

    public boolean isSlctMoreThan1Vaseteh() {
        return this.settingDao.getMSetup2Boolean(this.login, "SlctMoreThan1Vaseteh");
    }

    public boolean PorsantSatri() {
        return this.settingDao.getMSetup2Boolean(this.login, "PorsantSatri");
    }

    public boolean NoPorsant() {
        return this.settingDao.getMSetup2Boolean(this.login, "NoPorsant");
    }

    public boolean SaveCustForVaseteh() {
        return this.settingDao.getMSetup2Boolean(this.login, "SaveCustForVaseteh");
    }

    public boolean kartablFactureForUser() {
        return this.settingDao.getMSetup2Boolean(this.login, "KartablFacture" + this.login.getUserCodeInc());
    }

    public boolean kartablFactKharid() {
        return this.settingDao.getMSetup2Boolean(this.login, "KartablFactKharid" + this.login.getUserCodeInc());
    }

    public boolean kartablFactForosh() {
        return this.settingDao.getMSetup2Boolean(this.login, "KartablFactForosh" + this.login.getUserCodeInc());
    }

    public boolean kartablFactBargashtKharid() {
        return this.settingDao.getMSetup2Boolean(this.login, "KartablFactBargashtKharid" + this.login.getUserCodeInc());
    }

    public boolean kartablFactBargashtForosh() {
        return this.settingDao.getMSetup2Boolean(this.login, "KartablFactBargashtForosh" + this.login.getUserCodeInc());
    }

    public HolooSettingsDao getSettingDao() {
        return this.settingDao;
    }

    public void setSettingDao(HolooSettingsDao settingDao) {
        this.settingDao = settingDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SettingLoader)) {
            return false;
        }
        SettingLoader other = (SettingLoader)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LoginDto this$login = this.getLogin();
        LoginDto other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        HolooSettingsDao this$settingDao = this.getSettingDao();
        HolooSettingsDao other$settingDao = other.getSettingDao();
        return !(this$settingDao == null ? other$settingDao != null : !this$settingDao.equals(other$settingDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SettingLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoginDto $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        HolooSettingsDao $settingDao = this.getSettingDao();
        result = result * 59 + ($settingDao == null ? 43 : $settingDao.hashCode());
        return result;
    }

    public String toString() {
        return "SettingLoader(login=" + this.getLogin() + ", settingDao=" + this.getSettingDao() + ")";
    }

    public LoginDto getLogin() {
        return this.login;
    }
}

